#ifndef _VERSIPORT_H__
#define _VERSIPORT_H__

#include "CresnetStruct.h"
#include "OSCriticalSections.h"

// VERISPORT DRIVER

#define HYSTERESIS_ANLG_0   32          // this analog join set hyst for analog 0
#define OC_CTRL_DGTL_0      0          // this digital join sets open collector 0
#define VERSIPORT_PULLUP_OFFSET 32          // this digital join sets pullup 0
#define VERSIPORT_INPUT_OFFSET  96
#define VERSIPORT_CONFIGUREDAS_MIN_JOIN		128		// analog join to configure a pin (used by Prog 0)

#define SERIES_3_MIN_CHANGE_OFFSET  64 // Offset used for min change

#define VERSIPORT_POLL_TIME 100		// time in ms to poll for input changes

// tresholds for versiport analog
#define DIGI_LO_TRESH 0x3000            // if below this - its logical 1
#define DIGI_HI_TRESH 0x5000            // if above this - its logical 0
#define DEFAULT_HYSTERESIS  0x0800            // if no hysteresis specified

// definitions for lastReported
#define VP_DIGI_LO_REPORTED 0x01
#define VP_DIGI_HI_REPORTED 0x02
#define VP_ANLG_LO_REPORTED 0x03
#define VP_ANLG_HI_REPORTED 0x04

/*
Here is the valid definition of the digital signals:
0x00 - 0x07  =  get digital versiport input
versiport 1 - 8
0x08 - 0x0f  =  set digital versiport output
versiport 1 - 8
0x10 - 0x17  =  set 5 Volt output active on versiport output
versiport 1 - 8
here is the definition of the analog signals:
0x0 - 0x07  =  versiport analog inputs
versiport 1 - 8
0x08 - 0x0f  =  versiport analog input historehes
versiport 1 - 8
0x10 - 0x17  =  versiport input configuration
0 - off,1 - input digital,2 - input analog,3 - OK output,4 - 0-5v output
*/
typedef struct
{
  UINT16 m_iLastReported;
  UINT8 m_iInputConfig;  // 0 - off,1 - input digital,2 - input analog,3 - OK output,4 - 0-5v output
  
  // analog input is not active if digital input / output
  UINT16 m_iAnalogInput;
  UINT16 m_iAnalogHysteresis;
  bool m_bForceReport; // Flag signaling if the value of the port must be reported
} VERSIPORT_DATA;

class CVersiportDriver
{
public:
    CVersiportDriver(UINT8 NumPorts, UINT8 ThreadPriority, UINT8 Stream);

    void ProcessControlPacket(SET_VERSIPORT_PACKET *packet);
    void ConfigurePin(UINT32 Pin, UINT32 Value);		// used for Program 0 to configure individual pins
    UINT8 OutputDriver(UINT32 Join, UINT32 value);
	UINT8 SetHysteresis(UINT32 Join, UINT32 value);
	void ProcessEndOfUpdate(void);
	void ProcessAllClear(void);

	void VersiportUpdateTask(void);
	void VersiportReportChanges(UINT8 doReport)
	{
		m_ReportChanges = doReport;		// true if changes should be sent to Control system
	}

#ifdef DEBUG
	UINT8 mDebug;
	void VersiportDebug(UINT8 test);
#endif // DEBUG

private:
	void ReadAdcs(void);
	void InitHardware(void);

	UINT8 m_Stream;
	UINT8 m_NumPorts;
	UINT8 m_ReportChanges;
	VERSIPORT_DATA *m_pVdata;
    CriticalSection *m_pVportCS;		
};

extern CVersiportDriver *pVersiport;

#endif     // _VERSIPORT_H__

